// Please note that with a modal form, a submitButton element
// is required for the form's inputs to work
import * as vanillaC from "../vanilla/vanillaConst.js"
import * as dropdown from "./dropdownsContent.js"
import * as vMobs from "../vanilla/mobList.js"

/** @type {import("../def/formBuilds").FormList} */
export const ModalForms =
{
    "modal_menu": { // Menu
        title: "The Modal Menu",
        type: "action",
        elements: [
            {
                type: "header",
                headerText: "Modal Forms"
            },
            {
                type: "label",
                labelText: "Each button is a different type of modal form\n\nSome simple, some more advance"
            },
            {
                type: "divider"
            },
            {
                type: "button",
                buttonName: "Give\nTDP System",
                onClick: [
                    {type: "form", value: "modalGiveSystem"}
                ]
            },
            {
                type: "button",
                buttonName: "Add Tag\nWith Text Field",
                onClick: [
                    {type: "form", value: "modalAddTag"}
                ]
            },
            {
                type: "button",
                buttonName: "Remove Tag\nWith Dropdown",
                onClick: [
                    {type: "form", value: "modalRemoveTag"}
                ]
            },
            {
                type: "button",
                buttonName: "Apply Effects",
                onClick: [
                    {type: "form", value: "modalEffects"}
                ]
            },
            {
                type: "button",
                buttonName: "Apply Score\nWith Options",
                onClick: [
                    {type: "form", value: "modalScoreOptions"}
                ]
            },
            {
                type: "button",
                buttonName: "Apply Score\nSet Options",
                onClick: [
                    {type: "form", value: "modalScoreSet"}
                ]
            },
            {
                type: "button",
                buttonName: "Send Message\nWith Colour",
                onClick: [
                    {type: "form", value: "modalMessage"}
                ]
            },
            {
                type: "button",
                buttonName: "Change GameMode\nWith Confirm",
                onClick: [
                    {type: "form", value: "changeGameMode"}
                ]
            },
            {
                type: "button",
                buttonName: "Teleport to another player",
                onClick: [
                    {type: "form", value: "tpToPlayer"}
                ]
            },
            {
                type: "button",
                buttonName: "Summon mob at player's location",
                onClick: [
                    {type: "form", value: "summonMobAtPlayer"}
                ]
            },
            {
                type: "button",
                buttonName: "Summon mob at a set location",
                onClick: [
                    {type: "form", value: "summonMobAtLocation"}
                ]
            },
            {
                type: "button",
                buttonName: "Confirms a summon at a set location",
                onClick: [
                    {type: "form", value: "confirmSummonAtLocation"}
                ]
            },
            {
                type: "divider"
            },
            {
                type: "button",
                buttonName: "Change to Survival\nMessage Form",
                onClick: [
                    {type: "form", value: "confirmChange"}
                ]
            }
        ]
    },
    "modalAddTag": {
        title: "Add Tag Modal", // The title of the form
        type: "modal", // There are 3 types of forms: "action", "modal", & "message".
        // Modal is cool since you can have different element in it
        elements: [
            {
                type: "player", // Type player is a dropdown with all available player in the world
                label: "Player Selection", // The label of the element
                value: "selector" // The value to connect, we suggest that you use selector for target
            },
            {
                type: "textField", // Type textField is a text box that you can type anything in
                label: "Tags", // The label of the element
                placeholder: "Tags like members or owner", // Text Boxes can have placeholders to show a text before an input is typed in
                value: "tag" // The value to connect
            },
            {
                type: "submitButton", // Type submitButton is a required element, it is used to trigger an action
                label: "Give Tag", // The label of the button
                onSubmit: [ // onSubmit is similar to "action"s button's onClick, it is used to make an Array of actions
                    {
                        type: "add_tag", // The type is used to tell the system what kind of action to do
                        value: { // The value section is used to connect the other elements to the value
                            selector: "selector", // Selector is used to pick a target. Can be player's name, "all", "self", or the value from the player dropdowns
                            tag: "tag" // Tag is used to give a tag
                        }
                    }
                ]
            }
        ]
    },
    "modalRemoveTag": {
        title: "Remove Tag Modal",
        type: "modal",
        elements: [
            {
                type: "player",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "dropdown",
                label: "Tags",
                items: dropdown.removeTagTemps,
                value: "tag"
            },
            {
                type: "submitButton",
                label: "Take Tag",
                onSubmit: [
                    {
                        type: "remove_tag",
                        value: {
                            selector: "selector",
                            tag: "tag"
                        }
                    }
                ]
            }
        ]
    },
    "modalGiveSystem": {
        title: "The Modal Form",
        type: "modal",
        elements: [
            {
                type: "player",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "textField",
                label: "Item",
                placeholder: "e.g. 'minecraft:diamond'",
                value: "itemId"
            },
            {
                type: "slider",
                range: {
                    min: 1,
                    max: 100,
                    step: 1
                },
                label: "Amount",
                value: "amount"
            },
            {
                type: "submitButton",
                label: "Give Item",
                onSubmit: [
                    {
                        type: "give",
                        value: {
                            selector: "selector",
                            itemId: "itemId",
                            amount: "amount"
                        }
                    }
                ]
            }
        ]
    },
    "modalEffects": {
        title: "Give Effects",
        type: "modal",
        elements: [
            {
                type: "player",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "dropdown",
                default: 4,
                items: dropdown.vanillaEffects,
                label: "Potion Effects",
                value: "effects"
            },
            {
                type: "slider",
                range: {
                    min: 0,
                    max: 255,
                    step: 1
                },
                label: "Amplifier",
                value: "amplifier"
            },
            {
                type: "slider",
                label: "Duration(In Seconds)",
                range: {
                    min: 0,
                    max: 10000,
                    step: 1
                },
                value: "duration"
            },
            {
                type: "toggle",
                label: "Show Particles",
                default: true,
                value: "particles"
            },
            {
                type: "submitButton",
                label: "Give Effect",
                onSubmit: [
                    {
                        type: "effect",
                        value: {
                            selector: "selector",
                            effects: "effects",
                            amplifier: "amplifier",
                            duration: "duration",
                            particles: "particles"
                        }
                    }
                ]
            }
        ]
    },
    "modalScoreOptions": {
        title: "Scoreboard Options",
        type: "modal",
        elements: [
            {
                type: "player",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "dropdown",
                label: "The Objectives",
                items: [
                    "Wins",
                    "Loses"
                ],
                value: "objective"
            },
            {
                type: "slider",
                range: {
                    min: -10,
                    max: 10,
                    default: 0,
                    step: 1
                },
                label: "Score Change",
                value: "amount"
            },
            {
                type: "submitButton",
                label: "Apply Score",
                onSubmit: [
                    {
                        type: "scoreboard",
                        value: {
                            selector: "selector",
                            objective: "objective",
                            amount: "amount"
                        }
                    }
                ]
            }
        ]
    },
    "modalScoreSet": {
        title: "Scoreboard Set Self Objective",
        type: "modal",
        elements: [
            {
                type: "slider",
                range: {
                    min: -10,
                    max: 10,
                    default: 0,
                    step: 1
                },
                label: "Score Change",
                value: "amount"
            },
            {
                type: "submitButton",
                label: "Apply Score",
                onSubmit: [
                    {
                        type: "scoreboard",
                        value: {
                            selector: "all",
                            objective: "Wins",
                            amount: "amount"
                        }
                    }
                ]
            }
        ]
    },
    "modalMessage": {
        title: "Sends Message",
        type: "modal",
        elements: [
            {
                type: "textField",
                placeholder: "Send a message",
                label: "The Message",
                value: "text"
            },
            {
                type: "divider"
            },
            {
                type: "dropdown",
                tooltip: "Pick a colour",
                label: "Colours",
                items: Object.values(vanillaC.mcColorCodes),
                value: "colour"
            },
            {
                type: "dropdown",
                tooltip: "Pick a Style",
                label: "Style",
                items: Object.values(vanillaC.mcFormattingCodes),
                value: "style"
            },
            {
                type: "divider"
            },
            {
                type: "submitButton",
                label: "Send Message",
                onSubmit: [
                    {
                        type: "message",
                        value: {
                            selector: "all",
                            message: "text",
                            colour: "colour",
                            format: "style"
                        }
                    }
                ]
            }
        ]
    },
    "changeGameMode": {
        title: "Change Gamemodes",
        type: "modal",
        elements: [
            {
                type: "header",
                label: "GM Changer"
            },
            {
                type: "divider"
            },
            {
                type: "player",
                tooltip: "The player that will get the new gamemode. Only with people on the world/server.",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "dropdown",
                tooltip: "All the gamemode to choose from.",
                label: "Gamemodes",
                items: vanillaC.GameModeDD,
                value: "gamemode"
            },
            {
                type: "submitButton",
                label: "Change GM",
                onSubmit: [
                    {
                        type: "confirm",
                        value: {
                            selector: "selector",
                            gamemode: "gamemode"
                        },
                        body: "Are you sure you want to change {#SELECTOR}'s gamemode to {#GAMEMODE}?",
                        cancelText: "No",
                        confirmText: "Yes",
                        cancelAction: [
                            {type: "form", value: "changeGameMode"}
                        ],
                        confirmAction: [
                            {type: "gamemode", value: {selector: "{#SELECTOR}", gamemode: "{#GAMEMODE}"}}
                        ]
                    }
                ]
            }
        ]
    },
    "tpToPlayer": {
        type: "modal",
        title: "Teleport Player to Player",
        elements: [
            {
                type: "label",
                label: "This is for teleporting a Player to another Player"
            },
            {type: "divider"},
            {
                type: "player",
                label: "The Target Player",
                tooltip: "The Player that is being teleported.",
                value: "selector"
            },
            {
                type: "player",
                label: "The Destination Player",
                tooltip: "The Player that is being teleported to.",
                value: "destination"
            },
            {
                type: "submitButton",
                label: "!TELEPORT!",
                onSubmit: [
                    {
                        type: "tp",
                        value: {
                            selector: "selector",
                            destination: "destination"
                        }
                    }
                ]
            }
        ]
    },
    "summonMobAtPlayer": {
        title: "Summon mob at player",
        type: "modal",
        onOpen: [{type: "sound", value: "random.orb"}],
        elements: [
            {
                type: "label",
                label: "Pick an entity you want to summon and the player for its location"
            },
            {
                type: "dropdown",
                label: "Entities",
                tooltip: "Select an entity to spawn",
                items: Object.values(vMobs.allVanillaMobs),
                value: "entity"
            },
            {
                type: "player",
                tooltip: "Select a player to summon the mob to",
                label: "Player Selection",
                value: "selector"
            },
            {
                type: "submitButton",
                label: "Summon Entity At Player",
                onSubmit: [
                    {
                        type: "summon",
                        value: {
                            selector: "selector",
                            entity: "entity"
                        }
                    }
                ]
            }
        ]
    },
    "summonMobAtLocation": {
        title: "Summon mob at set location",
        type: "modal",
        onOpen: [{type: "sound", value: "random.orb"}],
        elements: [
            {
                type: "label",
                label: "Pick an entity you want to summon in the set location"
            },
            {
                type: "dropdown",
                label: "Entities",
                tooltip: "Select an entity to spawn",
                items: Object.values(vMobs.passiveMobs),
                value: "entity"
            },
            {
                type: "submitButton",
                label: "Summon Mob",
                onSubmit: [
                    {
                        type: "summon",
                        value: {
                            entity: "entity",
                            location: {
                                x: -34,
                                y: 72,
                                z: -11
                            }
                        }
                    }
                ]
            }
        ]
    },
    "confirmSummonAtLocationss": {
        title: "Summon mob at set location",
        type: "modal",
        onOpen: [{type: "sound", value: "random.orb"}],
        elements: [
            {
                type: "label",
                label: "Pick an entity you want to summon in the set location. Then it will ask you to confirm."
            },
            {
                type: "dropdown",
                label: "Entities",
                tooltip: "Select an entity to spawn",
                items: Object.values(vMobs.passiveMobs),
                value: "entity"
            },
            {
                type: "submitButton",
                label: "Summon",
                onSubmit: [
                    {
                        type: "confirm",
                        value: {
                            entity: "entity",
                            location: {
                                x: -34,
                                y: 72,
                                z: -11
                            }
                        },
                        body: "Are you sure you want to summon {#ENTITY} at these coordinates? (x: -34, y: 72, -11)",
                        cancelAction: [
                            {
                                type: "form",
                                value: "confirmSummonAtLocation"
                            }
                        ],
                        confirmAction: [
                            {
                                type: "summon",
                                value: {
                                    entity: "{#Entity}",
                                    location: {
                                        x: -34,
                                        y: 72,
                                        z: -11
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ]
    },
    "confirmSummonAtLocation": {
        title: "Summon mob at your location",
        type: "modal",
        onOpen: [{type: "sound", value: "random.orb"}],
        elements: [
            {
                type: "label",
                label: "Pick an entity you want to summon in the set location. Then it will ask you to confirm."
            },
            {
                type: "dropdown",
                label: "Entities",
                tooltip: "Select an entity to spawn",
                items: Object.values(vMobs.passiveMobs),
                value: "entity"
            },
            {
                type: "submitButton",
                label: "Summon",
                onSubmit: [
                    {
                        type: "confirm",
                        value: {
                            entity: "entity",
                            selector: "self"
                        },
                        body: "Are you sure you want to summon {#ENTITY} at your location",
                        cancelAction: [
                            {
                                type: "form",
                                value: "confirmSummonAtLocation"
                            }
                        ],
                        confirmAction: [
                            {
                                type: "summon",
                                value: {
                                    entity: "{#Entity}",
                                    selector: "{#SELF}"
                                }
                            }
                        ]
                    }
                ]
            }
        ]
    },
    "confirmChange": {
        type: "message",
        body: "Are you sure you want to go to survival mode",
        title: "Go to survival?",
        elements: [
            {
                type: "button1",
                onClick: [
                    {type: "say", value: "Didn't switch"}
                ]
            },
            {
                type: "button2",
                onClick: [
                    {type: "cmds", value: ["gamemode survival"]},
                    {type: "say", value: "Did switch"}
                ]
            }
        ]
    }
}